**********************************************************************************************
* Do-file used to impute owner-occupied housing assets based on wealth wealth surveys        *
**********************************************************************************************

* Imputation based on age groups.groups of total income

* I) Organize the data
***************************

	* Load the data
		use "$wfpat/wfEP04.dta",clear
		append using "$wfpat/wfEP10.dta"
		append using "$wfpat/wfEP98.dta"
		append using "$wfpat/wfEP92.dta"

	* Variables used for imputations

		* Age groups
			* 20-24, 25-30 , 31-39, 40-49, 50-54, 55-60, 61-65, 66-70, 71-80 and > 80 years old
			capture drop q_age_pr
			gen q_age_pr = 1
			replace q_age_pr = 2 if age >24
			replace q_age_pr = 3 if age >30
			replace q_age_pr = 4 if age >39
			replace q_age_pr = 5 if age >49
			replace q_age_pr = 6 if age >54
			replace q_age_pr = 7 if age >60
			replace q_age_pr = 8 if age >65
			replace q_age_pr = 9 if age >70
			tab q_age_pr [aw=pondn],missing

		* Age.groups of total income
			* For each age groups, decomposition in 7 groups of total income P0-25, P25-50, P50-75, P75-90, P90-95, P95-99, P99-100
			sort year q_age_pr rev_tot id_men
			gen u=13*uniform()
			replace rev_tot=u if rev_tot==0
			
			gen pondvr=round(100*pondn) 
			bys year q_age_pr : cumul rev_tot [w=pondvr], gen (p100)
			replace p100=p100*100
			capture drop q_age_rev 
			gen q_age_rev   = 0
			replace q_age_rev= 25   if p10 >=25 & p10 <50 & q_age_rev==0
			replace q_age_rev= 50   if p10 >=50 & p10 <75 & q_age_rev==0
			replace q_age_rev= 75   if p10 >=75 & p10 <90 & q_age_rev==0
			replace q_age_rev= 90   if p10 >=90 & p10 <95 & q_age_rev==0
			replace q_age_rev= 95   if p10 >=95 & p10 <99 & q_age_rev==0
			replace q_age_rev= 99   if p10 >=99 & q_age_rev==0
			drop p100 pondvr u
			/* Adjustment */
				replace q_age_rev=95 if  q_age_rev >=95 & (q_age_pr ==10 | q_age_pr ==1)
					
* II) Statistics for the imputation
*************************************			
		
	* Proportion of owner-occupied housing
		gen prop_immo =0 
		replace prop_immo =pondn if patfon_owner>0
	
	* Weighted amounts
		replace patfon_owner=patfon_owner*pondn
		replace passif_owner=passif_owner*pondn
	
	bys year q_age_pr q_age_rev  : egen tot=sum(pondn)
	gen a =1
	bys year q_age_pr q_age_rev  : egen obs=sum(a)
	drop a
	collapse (sum)  patfon_owner passif_owner prop_immo (mean) obs tot,by(year q_age_pr q_age_rev )
	
	* Proportion of owner-occupied housing by groups
		replace prop_immo=prop_immo/tot
	
	* Share of total owner-occupied housing assets accruing to each group
		bys year :egen patfon_owner_tot=sum(patfon_owner) 
		gen share_patimmo=100*patfon_owner/patfon_owner_tot
		gen ratio_pass_owner=passif_owner/patfon_owner
		replace ratio_pass_owner=0 if ratio_pass_owner==.
	
	/* To see average debts and owner-occupied housing assets of owners by groups 	
		foreach var of varlist passif_owner patfon_owner {
			replace `var'=`var'/tot/prop_immo if prop_immo~=0
		}
		gen patfon_owner_net=patfon_owner- passif_owner
		drop tot patfon_owner_net */
		
	keep year q* share* prop* ratio*
	
	tempfile base
	save "`base'",replace


* III) Harmonization and correction
*************************************
	
	* Interpolation for missing years		
		
		* Add missing years
		keep if year==1998
		foreach var of varlist year prop_immo share_patimmo ratio_pass_owner {
			replace `var'=.
		}
		tempfile temp
		save "`temp'",replace
		use "`base'",clear
		foreach num of numlist 1993/1997 1999/2003 2005/2009 {
			append using "`temp'"
			replace year=`num' if year==.
		}
		sort year
	
		* Years 1992, 1998, 2004 and 2010
		erase "`temp'"
		erase "`base'"
		tempfile newbase
		save "`newbase'",replace
		tempfile temp
		save "`temp'",replace
		foreach num of numlist 1992 1998 2004 2010 {
			use "`temp'",clear
			keep if year==`num'
			foreach var of varlist  prop_immo share_patimmo  ratio_pass_owner{
				rename `var' `var'`num'
			}
			drop year
			merge m:m q_age_pr q_age_rev  using "`newbase'"
			drop _merge
			erase "`newbase'"
			tempfile newbase
			save "`newbase'",replace
		}
		erase "`temp'"
		sort year q_age_pr q_age_rev 

	* Interpolation
	
		* Period 1993-1997
			local i =1992
			local j=1998
			foreach var of varlist  prop_immo share_patimmo ratio_pass_owner {
				replace `var'=`var'`i'+(`var'`j' -`var'`i')*(year-`i')/(`j'- `i') if year>`i' & year< `j'
			}
			
		* Period 1998-2004	
			local i =1998
			local j=2004
			foreach var of varlist  prop_immo share_patimmo ratio_pass_owner {
				replace `var'=`var'`i'+(`var'`j' -`var'`i')*(year-`i')/(`j'- `i') if year>`i' & year< `j'
			}
			
		* Period 2004-2010	
			local i =2004
			local j=2010
			foreach var of varlist  prop_immo share_patimmo ratio_pass_owner {
				replace `var'=`var'`i'+(`var'`j' -`var'`i')*(year-`i')/(`j'- `i') if year>`i' & year< `j'
			}
			
		drop *2010 *2004 *1998 *1992
		order year q_age_pr q_age_rev 
		sort year q_age_pr q_age_rev 

save "$param/Imputation/clef_immo_EPrevtot.dta",replace
			


